"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return MetaStats;
    }
});
const _httpClient = /*#__PURE__*/ _interop_require_default(require("./clients/httpClient"));
const _domainclient = /*#__PURE__*/ _interop_require_default(require("./clients/domain.client"));
const _metaStatsclient = /*#__PURE__*/ _interop_require_default(require("./clients/metaStats.client"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
let MetaStats = class MetaStats {
    /**
   * Returns the getMetrics MetaStatsClient method bound to the MetaStatsClient instance
   * @returns {Function} getMetrics MetaStatsClient method
   */ get getMetrics() {
        return this._metaStatsClient.getMetrics.bind(this._metaStatsClient);
    }
    /**
   * Returns the getAccountTrades MetaStatsClient method bound to the MetaStatsClient instance
   * @returns {Function} getAccountTrades MetaStatsClient method
   */ get getAccountTrades() {
        return this._metaStatsClient.getAccountTrades.bind(this._metaStatsClient);
    }
    /**
   * Returns the getAccountOpenTrades MetaStatsClient method bound to the MetaStatsClient instance
   * @returns {Function} getAccountOpenTrades MetaStatsClient method
   */ get getAccountOpenTrades() {
        return this._metaStatsClient.getAccountOpenTrades.bind(this._metaStatsClient);
    }
    /**
   * @typedef {Object} ConnectionOptions connection options
   * @property {Number} [requestTimeout] request timeout in seconds, default 60
   * @property {String} [domain] request domain, default 'agiliumtrade.agiliumtrade.ai'
   * @property {RetryOptions} [retryOpts] retry options
   */ /**
   * Constructs MetaStats class instance
   * @param {String} token authorization token
   * @param {ConnectionOptions} [opts] connection options
   */ constructor(token, opts = {}){
        const httpClient = new _httpClient.default(opts.requestTimeout, opts.retryOpts);
        const domainClient = new _domainclient.default(httpClient, token, opts.domain);
        this._metaStatsClient = new _metaStatsclient.default(domainClient);
    }
};

//# sourceMappingURL=data:application/json;base64,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