'use strict';

var _httpClient = require('../httpClient');

var _httpClient2 = _interopRequireDefault(_httpClient);

var _sinon = require('sinon');

var _sinon2 = _interopRequireDefault(_sinon);

var _expertAdvisor = require('./expertAdvisor.client');

var _expertAdvisor2 = _interopRequireDefault(_expertAdvisor);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const provisioningApiUrl = 'https://mt-provisioning-api-v1.agiliumtrade.agiliumtrade.ai';

/**
 * @test {ExpertAdvisorClient}
 */
describe('ExpertAdvisorClient', () => {

  let expertAdvisorClient;
  const token = 'header.payload.sign';
  let httpClient = new _httpClient2.default();
  let sandbox;
  let requestStub;

  before(() => {
    sandbox = _sinon2.default.createSandbox();
  });

  beforeEach(() => {
    expertAdvisorClient = new _expertAdvisor2.default(httpClient, token);
    requestStub = sandbox.stub(httpClient, 'request');
  });

  afterEach(() => {
    sandbox.restore();
  });

  /**
   * @test {ExpertAdvisorClient#getExpertAdvisors}
   */
  it('should retrieve expert advisors from API', async () => {
    const expected = [{
      expertId: 'my-ea',
      period: '1H',
      symbol: 'EURUSD',
      fileUploaded: false
    }];
    requestStub.resolves(expected);
    let expertAdvisors = await expertAdvisorClient.getExpertAdvisors('id');
    expertAdvisors.should.equal(expected);
    _sinon2.default.assert.calledOnceWithExactly(httpClient.request, {
      url: `${provisioningApiUrl}/users/current/accounts/id/expert-advisors`,
      method: 'GET',
      headers: {
        'auth-token': token
      },
      json: true
    });
  });

  /**
   * @test {ExpertAdvisorClient#getExpertAdvisor}
   */
  it('should retrieve expert advisor from API', async () => {
    let expected = {
      expertId: 'my-ea',
      period: '1H',
      symbol: 'EURUSD',
      fileUploaded: false
    };
    requestStub.resolves(expected);
    let advisor = await expertAdvisorClient.getExpertAdvisor('id', 'my-ea');
    advisor.should.equal(expected);
    _sinon2.default.assert.calledOnceWithExactly(httpClient.request, {
      url: `${provisioningApiUrl}/users/current/accounts/id/expert-advisors/my-ea`,
      method: 'GET',
      headers: {
        'auth-token': token
      },
      json: true
    });
  });

  /**
   * @test {ExpertAdvisorClient#deleteExpertAdvisor}
   */
  it('should delete expert advisor via API', async () => {
    await expertAdvisorClient.deleteExpertAdvisor('id', 'my-ea');
    _sinon2.default.assert.calledOnceWithExactly(httpClient.request, {
      url: `${provisioningApiUrl}/users/current/accounts/id/expert-advisors/my-ea`,
      method: 'DELETE',
      headers: {
        'auth-token': token
      },
      json: true
    });
  });

  /**
   * @test {ExpertAdvisorClient#updateExpertAdvisor}
   */
  it('should update expert advisor via API', async () => {
    await expertAdvisorClient.updateExpertAdvisor('id', 'my-ea', {
      preset: 'a2V5MT12YWx1ZTEKa2V5Mj12YWx1ZTIKa2V5Mz12YWx1ZTMKc3VwZXI9dHJ1ZQ==',
      period: '15m',
      symbol: 'EURUSD'
    });
    _sinon2.default.assert.calledOnceWithExactly(httpClient.request, {
      url: `${provisioningApiUrl}/users/current/accounts/id/expert-advisors/my-ea`,
      method: 'PUT',
      headers: {
        'auth-token': token
      },
      json: true,
      body: {
        preset: 'a2V5MT12YWx1ZTEKa2V5Mj12YWx1ZTIKa2V5Mz12YWx1ZTMKc3VwZXI9dHJ1ZQ==',
        period: '15m',
        symbol: 'EURUSD'
      }
    });
  });

  /**
   * @test {ExpertAdvisorClient#uploadExpertAdvisorFile}
   */
  it('should upload file to a expert advisor via API', async () => {
    let file = Buffer.from('test', 'utf8');
    await expertAdvisorClient.uploadExpertAdvisorFile('id', 'my-ea', file);
    _sinon2.default.assert.calledOnceWithExactly(httpClient.request, {
      url: `${provisioningApiUrl}/users/current/accounts/id/expert-advisors/my-ea/file`,
      method: 'PUT',
      headers: {
        'auth-token': token
      },
      formData: {
        file
      },
      json: true
    });
  });
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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