'use strict';

var _httpClient = require('../httpClient');

var _httpClient2 = _interopRequireDefault(_httpClient);

var _sinon = require('sinon');

var _sinon2 = _interopRequireDefault(_sinon);

var _metatraderDemoAccount = require('./metatraderDemoAccount.client');

var _metatraderDemoAccount2 = _interopRequireDefault(_metatraderDemoAccount);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const provisioningApiUrl = 'https://mt-provisioning-api-v1.agiliumtrade.agiliumtrade.ai';

/**
 * @test {MetatraderDemoAccountClient}
 */
describe('MetatraderDemoAccountClient', () => {

  let demoAccountClient;
  const token = 'header.payload.sign';
  let httpClient = new _httpClient2.default();
  let sandbox;
  let requestStub;

  before(() => {
    sandbox = _sinon2.default.createSandbox();
  });

  beforeEach(() => {
    demoAccountClient = new _metatraderDemoAccount2.default(httpClient, token);
    requestStub = sandbox.stub(httpClient, 'request');
  });

  afterEach(() => {
    sandbox.restore();
  });

  /**
   * @test {MetatraderDemoAccountClient#createMT4DemoAccount}
   */
  it('should create new MetaTrader 4 demo from API', async () => {
    let expected = { login: '12345', password: 'qwerty', serverName: 'HugosWay-Demo3', investorPassword: 'qwerty' };
    requestStub.resolves(expected);
    let account = await demoAccountClient.createMT4DemoAccount('profileId1', {
      balance: 10,
      email: 'test@test.com',
      leverage: 15,
      serverName: 'server'
    });
    account.should.equal(expected);
    _sinon2.default.assert.calledOnceWithExactly(httpClient.request, {
      url: `${provisioningApiUrl}/users/current/provisioning-profiles/profileId1/mt4-demo-accounts`,
      method: 'POST',
      headers: {
        'auth-token': token
      },
      body: {
        balance: 10,
        email: 'test@test.com',
        leverage: 15,
        serverName: 'server'
      },
      json: true
    });
  });

  /**
   * @test {MetatraderDemoAccountClient#createMT4DemoAccount}
   */
  it('should not create MetaTrader 4 account via API with account token', async () => {
    demoAccountClient = new _metatraderDemoAccount2.default(httpClient, 'token');
    try {
      await demoAccountClient.createMT4DemoAccount('profileId1', {});
    } catch (error) {
      error.message.should.equal('You can not invoke createMT4DemoAccount method, because you have connected with account access token. ' + 'Please use API access token from https://app.metaapi.cloud/token page to invoke this method.');
    }
  });

  /**
   * @test {MetatraderDemoAccountClient#getAccounts}
   */
  it('should create new MetaTrader 5 demo from API', async () => {
    let expected = { login: '12345', password: 'qwerty', serverName: 'HugosWay-Demo3', investorPassword: 'qwerty' };
    requestStub.resolves(expected);
    let account = await demoAccountClient.createMT5DemoAccount('profileId2', {
      balance: 10,
      email: 'test@test.com',
      leverage: 15,
      serverName: 'server'
    });
    account.should.equal(expected);
    _sinon2.default.assert.calledOnceWithExactly(httpClient.request, {
      url: `${provisioningApiUrl}/users/current/provisioning-profiles/profileId2/mt5-demo-accounts`,
      method: 'POST',
      headers: {
        'auth-token': token
      },
      body: {
        balance: 10,
        email: 'test@test.com',
        leverage: 15,
        serverName: 'server'
      },
      json: true
    });
  });

  /**
   * @test {MetatraderDemoAccountClient#createMT5DemoAccount}
   */
  it('should not create MetaTrader 5 account via API with account token', async () => {
    demoAccountClient = new _metatraderDemoAccount2.default(httpClient, 'token');
    try {
      await demoAccountClient.createMT5DemoAccount('profileId1', {});
    } catch (error) {
      error.message.should.equal('You can not invoke createMT5DemoAccount method, because you have connected with account access token. ' + 'Please use API access token from https://app.metaapi.cloud/token page to invoke this method.');
    }
  });
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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