/* jscs:disable */
/* eslint-disable */

'use strict';

function createNewNode_(key) {
  return {
    key: key,
    weight: 1,
    height: 0,
    left: null,
    right: null
  };
}

var comparer_ = function (a, b) {
  if (a < b) return -1;
  if (a > b) return 1;
  return 0;
};

function height_(p) {
  return p ? p.height : 0;
}

function weight_(p) {
  return p ? p.weight : 0;
}

function bFactor_(p) {
  return height_(p.right) - height_(p.left);
}

function countHeightAndWeight_(p) {
  var hl = height_(p.left);
  var hr = height_(p.right);
  p.height = (hl > hr ? hl : hr) + 1;

  var wl = weight_(p.left);
  var wr = weight_(p.right);
  p.weight = wl + wr + 1;
}

function rotateRight_(p) {
  var q = p.left;
  p.left = q.right;
  q.right = p;
  countHeightAndWeight_(p);
  countHeightAndWeight_(q);
  return q;
}

function rotateLeft_(q) {
  var p = q.right;
  q.right = p.left;
  p.left = q;
  countHeightAndWeight_(q);
  countHeightAndWeight_(p);
  return p;
}

function balance_(p) {
  countHeightAndWeight_(p);
  if (bFactor_(p) === 2) {
    if (bFactor_(p.right) < 0) p.right = rotateRight_(p.right);
    return rotateLeft_(p);
  }
  if (bFactor_(p) === -2) {
    if (bFactor_(p.left) > 0) p.left = rotateLeft_(p.left);
    return rotateRight_(p);
  }
  return p;
}

function count_(p, k) {
  return upperBound_(p, k) - lowerBound_(p, k);
}

function at_(p, k) {
  if (!p) return null;
  var wl = weight_(p.left);
  if (wl <= k && k < wl + 1) return p.key;else if (k < wl) return at_(p.left, k);else return at_(p.right, k - wl - 1);
}

function getMinimum_(p) {
  if (!p) return null;
  return p.left ? getMinimum_(p.left) : p;
}

function getMaximum_(p) {
  if (!p) return null;
  return p.right ? getMaximum_(p.right) : p;
}

function removeMinimun_(p) {
  if (!p.left) return p.right;
  p.left = removeMinimun_(p.left);
  return balance_(p);
}

function toArray_(p) {
  var arr = [];
  if (p.left) arr = arr.concat(toArray_(p.left));
  arr.push(p.key);
  if (p.right) arr = arr.concat(toArray_(p.right));
  return arr;
}

var AVLTree = function (comparer) {
  if (!comparer) comparer = comparer_;
  var AVL = {
    root: null,
    comparer_: comparer,

    size: function () {
      return weight_(AVL.root);
    },

    min: function () {
      var p = getMinimum_(AVL.root);
      if (p) return p.key;
      return null;
    },

    max: function () {
      var p = getMaximum_(AVL.root);
      if (p) return p.key;
      return null;
    },

    lowerBound: function (k) {
      return AVL.lowerBound_(AVL.root, k);
    },
    lowerBound_(p, k) {
      if (!p) return 0;
      var cmp = AVL.comparer_(k, p.key);

      if (cmp <= 0) return AVL.lowerBound_(p.left, k);else if (cmp > 0) return weight_(p.left) + AVL.lowerBound_(p.right, k) + 1;
    },

    upperBound: function (k) {
      return AVL.upperBound_(AVL.root, k);
    },

    upperBound_(p, k) {
      if (!p) return 0;
      var cmp = AVL.comparer_(k, p.key);

      if (cmp < 0) return AVL.upperBound_(p.left, k);else if (cmp >= 0) return weight_(p.left) + AVL.upperBound_(p.right, k) + 1;
    },

    count: function (k) {
      return count_(AVL.root, k);
    },

    at: function (k) {
      return at_(AVL.root, k);
    },

    insert: function (k) {
      AVL.root = AVL.insert_(AVL.root, k);
    },

    insert_(p, k) {
      if (!p) return createNewNode_(k);
      var cmp = AVL.comparer_(k, p.key);

      if (cmp < 0) p.left = AVL.insert_(p.left, k);else if (cmp >= 0) p.right = AVL.insert_(p.right, k);
      return balance_(p);
    },

    remove: function (k) {
      AVL.root = AVL.remove_(AVL.root, k);
    },

    remove_(p, k) {
      if (!p) return null;
      var cmp = AVL.comparer_(k, p.key);

      if (cmp < 0) p.left = AVL.remove_(p.left, k);else if (cmp > 0) p.right = AVL.remove_(p.right, k);else {
        var q = p.left;
        var r = p.right;
        if (!r) return q;

        var min = getMinimum_(r);
        min.right = removeMinimun_(r);
        min.left = q;
        return balance_(min);
      }
      return balance_(p);
    },

    removeAt: function (k) {
      var val = AVL.at(k);
      AVL.root = AVL.remove_(AVL.root, val);
    },

    toArray: function () {
      if (AVL.root === null) return [];
      return toArray_(AVL.root);
    }
  };
  return AVL;
};

module.exports = AVLTree;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uL2xpYi9tZXRhQXBpL3Jlc2Vydm9pci9hdmxUcmVlLmVzNiJdLCJuYW1lcyI6WyJjcmVhdGVOZXdOb2RlXyIsImtleSIsIndlaWdodCIsImhlaWdodCIsImxlZnQiLCJyaWdodCIsImNvbXBhcmVyXyIsImEiLCJiIiwiaGVpZ2h0XyIsInAiLCJ3ZWlnaHRfIiwiYkZhY3Rvcl8iLCJjb3VudEhlaWdodEFuZFdlaWdodF8iLCJobCIsImhyIiwid2wiLCJ3ciIsInJvdGF0ZVJpZ2h0XyIsInEiLCJyb3RhdGVMZWZ0XyIsImJhbGFuY2VfIiwiY291bnRfIiwiayIsInVwcGVyQm91bmRfIiwibG93ZXJCb3VuZF8iLCJhdF8iLCJnZXRNaW5pbXVtXyIsImdldE1heGltdW1fIiwicmVtb3ZlTWluaW11bl8iLCJ0b0FycmF5XyIsImFyciIsImNvbmNhdCIsInB1c2giLCJBVkxUcmVlIiwiY29tcGFyZXIiLCJBVkwiLCJyb290Iiwic2l6ZSIsIm1pbiIsIm1heCIsImxvd2VyQm91bmQiLCJjbXAiLCJ1cHBlckJvdW5kIiwiY291bnQiLCJhdCIsImluc2VydCIsImluc2VydF8iLCJyZW1vdmUiLCJyZW1vdmVfIiwiciIsInJlbW92ZUF0IiwidmFsIiwidG9BcnJheSIsIm1vZHVsZSIsImV4cG9ydHMiXSwibWFwcGluZ3MiOiJBQUFBO0FBQ0E7O0FBRUE7O0FBRUEsU0FBU0EsY0FBVCxDQUF3QkMsR0FBeEIsRUFBNkI7QUFDM0IsU0FBTztBQUNMQSxTQUFLQSxHQURBO0FBRUxDLFlBQVEsQ0FGSDtBQUdMQyxZQUFRLENBSEg7QUFJTEMsVUFBTSxJQUpEO0FBS0xDLFdBQU87QUFMRixHQUFQO0FBT0Q7O0FBRUQsSUFBSUMsWUFBWSxVQUFTQyxDQUFULEVBQVlDLENBQVosRUFBZTtBQUM3QixNQUFJRCxJQUFJQyxDQUFSLEVBQVcsT0FBTyxDQUFDLENBQVI7QUFDWCxNQUFJRCxJQUFJQyxDQUFSLEVBQVcsT0FBTyxDQUFQO0FBQ1gsU0FBTyxDQUFQO0FBQ0QsQ0FKRDs7QUFNQSxTQUFTQyxPQUFULENBQWlCQyxDQUFqQixFQUFvQjtBQUNsQixTQUFPQSxJQUFJQSxFQUFFUCxNQUFOLEdBQWUsQ0FBdEI7QUFDRDs7QUFFRCxTQUFTUSxPQUFULENBQWlCRCxDQUFqQixFQUFvQjtBQUNsQixTQUFPQSxJQUFJQSxFQUFFUixNQUFOLEdBQWUsQ0FBdEI7QUFDRDs7QUFFRCxTQUFTVSxRQUFULENBQWtCRixDQUFsQixFQUFxQjtBQUNuQixTQUFPRCxRQUFRQyxFQUFFTCxLQUFWLElBQW1CSSxRQUFRQyxFQUFFTixJQUFWLENBQTFCO0FBQ0Q7O0FBRUQsU0FBU1MscUJBQVQsQ0FBK0JILENBQS9CLEVBQWtDO0FBQ2hDLE1BQUlJLEtBQUtMLFFBQVFDLEVBQUVOLElBQVYsQ0FBVDtBQUNBLE1BQUlXLEtBQUtOLFFBQVFDLEVBQUVMLEtBQVYsQ0FBVDtBQUNBSyxJQUFFUCxNQUFGLEdBQVcsQ0FBQ1csS0FBS0MsRUFBTCxHQUFVRCxFQUFWLEdBQWVDLEVBQWhCLElBQXNCLENBQWpDOztBQUVBLE1BQUlDLEtBQUtMLFFBQVFELEVBQUVOLElBQVYsQ0FBVDtBQUNBLE1BQUlhLEtBQUtOLFFBQVFELEVBQUVMLEtBQVYsQ0FBVDtBQUNBSyxJQUFFUixNQUFGLEdBQVdjLEtBQUtDLEVBQUwsR0FBVSxDQUFyQjtBQUNEOztBQUVELFNBQVNDLFlBQVQsQ0FBc0JSLENBQXRCLEVBQXlCO0FBQ3ZCLE1BQUlTLElBQUlULEVBQUVOLElBQVY7QUFDQU0sSUFBRU4sSUFBRixHQUFTZSxFQUFFZCxLQUFYO0FBQ0FjLElBQUVkLEtBQUYsR0FBVUssQ0FBVjtBQUNBRyx3QkFBc0JILENBQXRCO0FBQ0FHLHdCQUFzQk0sQ0FBdEI7QUFDQSxTQUFPQSxDQUFQO0FBQ0Q7O0FBRUQsU0FBU0MsV0FBVCxDQUFxQkQsQ0FBckIsRUFBd0I7QUFDdEIsTUFBSVQsSUFBSVMsRUFBRWQsS0FBVjtBQUNBYyxJQUFFZCxLQUFGLEdBQVVLLEVBQUVOLElBQVo7QUFDQU0sSUFBRU4sSUFBRixHQUFTZSxDQUFUO0FBQ0FOLHdCQUFzQk0sQ0FBdEI7QUFDQU4sd0JBQXNCSCxDQUF0QjtBQUNBLFNBQU9BLENBQVA7QUFDRDs7QUFFRCxTQUFTVyxRQUFULENBQWtCWCxDQUFsQixFQUFxQjtBQUNuQkcsd0JBQXNCSCxDQUF0QjtBQUNBLE1BQUlFLFNBQVNGLENBQVQsTUFBZ0IsQ0FBcEIsRUFBdUI7QUFDckIsUUFBSUUsU0FBU0YsRUFBRUwsS0FBWCxJQUFvQixDQUF4QixFQUNFSyxFQUFFTCxLQUFGLEdBQVVhLGFBQWFSLEVBQUVMLEtBQWYsQ0FBVjtBQUNGLFdBQU9lLFlBQVlWLENBQVosQ0FBUDtBQUNEO0FBQ0QsTUFBSUUsU0FBU0YsQ0FBVCxNQUFnQixDQUFDLENBQXJCLEVBQXdCO0FBQ3RCLFFBQUlFLFNBQVNGLEVBQUVOLElBQVgsSUFBbUIsQ0FBdkIsRUFDRU0sRUFBRU4sSUFBRixHQUFTZ0IsWUFBWVYsRUFBRU4sSUFBZCxDQUFUO0FBQ0YsV0FBT2MsYUFBYVIsQ0FBYixDQUFQO0FBQ0Q7QUFDRCxTQUFPQSxDQUFQO0FBQ0Q7O0FBRUQsU0FBU1ksTUFBVCxDQUFnQlosQ0FBaEIsRUFBbUJhLENBQW5CLEVBQXNCO0FBQ3BCLFNBQU9DLFlBQVlkLENBQVosRUFBZWEsQ0FBZixJQUFvQkUsWUFBWWYsQ0FBWixFQUFlYSxDQUFmLENBQTNCO0FBQ0Q7O0FBRUQsU0FBU0csR0FBVCxDQUFhaEIsQ0FBYixFQUFnQmEsQ0FBaEIsRUFBbUI7QUFDakIsTUFBSSxDQUFDYixDQUFMLEVBQVEsT0FBTyxJQUFQO0FBQ1IsTUFBSU0sS0FBS0wsUUFBUUQsRUFBRU4sSUFBVixDQUFUO0FBQ0EsTUFBSVksTUFBTU8sQ0FBTixJQUFXQSxJQUFJUCxLQUFLLENBQXhCLEVBQTJCLE9BQU9OLEVBQUVULEdBQVQsQ0FBM0IsS0FDSyxJQUFJc0IsSUFBSVAsRUFBUixFQUFZLE9BQU9VLElBQUloQixFQUFFTixJQUFOLEVBQVltQixDQUFaLENBQVAsQ0FBWixLQUNBLE9BQU9HLElBQUloQixFQUFFTCxLQUFOLEVBQWFrQixJQUFJUCxFQUFKLEdBQVMsQ0FBdEIsQ0FBUDtBQUNOOztBQUVELFNBQVNXLFdBQVQsQ0FBcUJqQixDQUFyQixFQUF3QjtBQUN0QixNQUFJLENBQUNBLENBQUwsRUFBUSxPQUFPLElBQVA7QUFDUixTQUFPQSxFQUFFTixJQUFGLEdBQVN1QixZQUFZakIsRUFBRU4sSUFBZCxDQUFULEdBQStCTSxDQUF0QztBQUNEOztBQUVELFNBQVNrQixXQUFULENBQXFCbEIsQ0FBckIsRUFBd0I7QUFDdEIsTUFBSSxDQUFDQSxDQUFMLEVBQVEsT0FBTyxJQUFQO0FBQ1IsU0FBT0EsRUFBRUwsS0FBRixHQUFVdUIsWUFBWWxCLEVBQUVMLEtBQWQsQ0FBVixHQUFpQ0ssQ0FBeEM7QUFDRDs7QUFFRCxTQUFTbUIsY0FBVCxDQUF3Qm5CLENBQXhCLEVBQTJCO0FBQ3pCLE1BQUksQ0FBQ0EsRUFBRU4sSUFBUCxFQUFhLE9BQU9NLEVBQUVMLEtBQVQ7QUFDYkssSUFBRU4sSUFBRixHQUFTeUIsZUFBZW5CLEVBQUVOLElBQWpCLENBQVQ7QUFDQSxTQUFPaUIsU0FBU1gsQ0FBVCxDQUFQO0FBQ0Q7O0FBRUQsU0FBU29CLFFBQVQsQ0FBa0JwQixDQUFsQixFQUFxQjtBQUNuQixNQUFJcUIsTUFBTSxFQUFWO0FBQ0EsTUFBSXJCLEVBQUVOLElBQU4sRUFBWTJCLE1BQU1BLElBQUlDLE1BQUosQ0FBV0YsU0FBU3BCLEVBQUVOLElBQVgsQ0FBWCxDQUFOO0FBQ1oyQixNQUFJRSxJQUFKLENBQVN2QixFQUFFVCxHQUFYO0FBQ0EsTUFBSVMsRUFBRUwsS0FBTixFQUFhMEIsTUFBTUEsSUFBSUMsTUFBSixDQUFXRixTQUFTcEIsRUFBRUwsS0FBWCxDQUFYLENBQU47QUFDYixTQUFPMEIsR0FBUDtBQUNEOztBQUVELElBQUlHLFVBQVUsVUFBU0MsUUFBVCxFQUFtQjtBQUMvQixNQUFJLENBQUNBLFFBQUwsRUFBZUEsV0FBVzdCLFNBQVg7QUFDZixNQUFJOEIsTUFBTTtBQUNSQyxVQUFNLElBREU7QUFFUi9CLGVBQVc2QixRQUZIOztBQUlSRyxVQUFNLFlBQVc7QUFDZixhQUFPM0IsUUFBUXlCLElBQUlDLElBQVosQ0FBUDtBQUNELEtBTk87O0FBUVJFLFNBQUssWUFBVztBQUNkLFVBQUk3QixJQUFJaUIsWUFBWVMsSUFBSUMsSUFBaEIsQ0FBUjtBQUNBLFVBQUkzQixDQUFKLEVBQU8sT0FBT0EsRUFBRVQsR0FBVDtBQUNQLGFBQU8sSUFBUDtBQUNELEtBWk87O0FBY1J1QyxTQUFLLFlBQVc7QUFDZCxVQUFJOUIsSUFBSWtCLFlBQVlRLElBQUlDLElBQWhCLENBQVI7QUFDQSxVQUFJM0IsQ0FBSixFQUFPLE9BQU9BLEVBQUVULEdBQVQ7QUFDUCxhQUFPLElBQVA7QUFDRCxLQWxCTzs7QUFvQlJ3QyxnQkFBWSxVQUFTbEIsQ0FBVCxFQUFZO0FBQ3RCLGFBQU9hLElBQUlYLFdBQUosQ0FBZ0JXLElBQUlDLElBQXBCLEVBQTBCZCxDQUExQixDQUFQO0FBQ0QsS0F0Qk87QUF1QlJFLGdCQUFZZixDQUFaLEVBQWVhLENBQWYsRUFBa0I7QUFDaEIsVUFBSSxDQUFDYixDQUFMLEVBQVEsT0FBTyxDQUFQO0FBQ1IsVUFBSWdDLE1BQU1OLElBQUk5QixTQUFKLENBQWNpQixDQUFkLEVBQWlCYixFQUFFVCxHQUFuQixDQUFWOztBQUVBLFVBQUl5QyxPQUFPLENBQVgsRUFBYyxPQUFPTixJQUFJWCxXQUFKLENBQWdCZixFQUFFTixJQUFsQixFQUF3Qm1CLENBQXhCLENBQVAsQ0FBZCxLQUNLLElBQUltQixNQUFNLENBQVYsRUFBYSxPQUFPL0IsUUFBUUQsRUFBRU4sSUFBVixJQUFrQmdDLElBQUlYLFdBQUosQ0FBZ0JmLEVBQUVMLEtBQWxCLEVBQXlCa0IsQ0FBekIsQ0FBbEIsR0FBZ0QsQ0FBdkQ7QUFDbkIsS0E3Qk87O0FBK0JSb0IsZ0JBQVksVUFBU3BCLENBQVQsRUFBWTtBQUN0QixhQUFPYSxJQUFJWixXQUFKLENBQWdCWSxJQUFJQyxJQUFwQixFQUEwQmQsQ0FBMUIsQ0FBUDtBQUNELEtBakNPOztBQW1DUkMsZ0JBQVlkLENBQVosRUFBZWEsQ0FBZixFQUFrQjtBQUNoQixVQUFJLENBQUNiLENBQUwsRUFBUSxPQUFPLENBQVA7QUFDUixVQUFJZ0MsTUFBTU4sSUFBSTlCLFNBQUosQ0FBY2lCLENBQWQsRUFBaUJiLEVBQUVULEdBQW5CLENBQVY7O0FBRUEsVUFBSXlDLE1BQU0sQ0FBVixFQUFhLE9BQU9OLElBQUlaLFdBQUosQ0FBZ0JkLEVBQUVOLElBQWxCLEVBQXdCbUIsQ0FBeEIsQ0FBUCxDQUFiLEtBQ0ssSUFBSW1CLE9BQU8sQ0FBWCxFQUFjLE9BQU8vQixRQUFRRCxFQUFFTixJQUFWLElBQWtCZ0MsSUFBSVosV0FBSixDQUFnQmQsRUFBRUwsS0FBbEIsRUFBeUJrQixDQUF6QixDQUFsQixHQUFnRCxDQUF2RDtBQUNwQixLQXpDTzs7QUEyQ1JxQixXQUFPLFVBQVNyQixDQUFULEVBQVk7QUFDakIsYUFBT0QsT0FBT2MsSUFBSUMsSUFBWCxFQUFpQmQsQ0FBakIsQ0FBUDtBQUNELEtBN0NPOztBQStDUnNCLFFBQUksVUFBU3RCLENBQVQsRUFBWTtBQUNkLGFBQU9HLElBQUlVLElBQUlDLElBQVIsRUFBY2QsQ0FBZCxDQUFQO0FBQ0QsS0FqRE87O0FBbURSdUIsWUFBUSxVQUFTdkIsQ0FBVCxFQUFZO0FBQ2xCYSxVQUFJQyxJQUFKLEdBQVdELElBQUlXLE9BQUosQ0FBWVgsSUFBSUMsSUFBaEIsRUFBc0JkLENBQXRCLENBQVg7QUFDRCxLQXJETzs7QUF1RFJ3QixZQUFRckMsQ0FBUixFQUFXYSxDQUFYLEVBQWM7QUFDWixVQUFJLENBQUNiLENBQUwsRUFBUSxPQUFPVixlQUFldUIsQ0FBZixDQUFQO0FBQ1IsVUFBSW1CLE1BQU1OLElBQUk5QixTQUFKLENBQWNpQixDQUFkLEVBQWlCYixFQUFFVCxHQUFuQixDQUFWOztBQUVBLFVBQUl5QyxNQUFNLENBQVYsRUFBYWhDLEVBQUVOLElBQUYsR0FBU2dDLElBQUlXLE9BQUosQ0FBWXJDLEVBQUVOLElBQWQsRUFBb0JtQixDQUFwQixDQUFULENBQWIsS0FDSyxJQUFJbUIsT0FBTyxDQUFYLEVBQWNoQyxFQUFFTCxLQUFGLEdBQVUrQixJQUFJVyxPQUFKLENBQVlyQyxFQUFFTCxLQUFkLEVBQXFCa0IsQ0FBckIsQ0FBVjtBQUNuQixhQUFPRixTQUFTWCxDQUFULENBQVA7QUFDRCxLQTlETzs7QUFnRVJzQyxZQUFRLFVBQVN6QixDQUFULEVBQVk7QUFDbEJhLFVBQUlDLElBQUosR0FBV0QsSUFBSWEsT0FBSixDQUFZYixJQUFJQyxJQUFoQixFQUFzQmQsQ0FBdEIsQ0FBWDtBQUNELEtBbEVPOztBQW9FUjBCLFlBQVF2QyxDQUFSLEVBQVdhLENBQVgsRUFBYztBQUNaLFVBQUksQ0FBQ2IsQ0FBTCxFQUFRLE9BQU8sSUFBUDtBQUNSLFVBQUlnQyxNQUFNTixJQUFJOUIsU0FBSixDQUFjaUIsQ0FBZCxFQUFpQmIsRUFBRVQsR0FBbkIsQ0FBVjs7QUFFQSxVQUFJeUMsTUFBTSxDQUFWLEVBQWFoQyxFQUFFTixJQUFGLEdBQVNnQyxJQUFJYSxPQUFKLENBQVl2QyxFQUFFTixJQUFkLEVBQW9CbUIsQ0FBcEIsQ0FBVCxDQUFiLEtBQ0ssSUFBSW1CLE1BQU0sQ0FBVixFQUFhaEMsRUFBRUwsS0FBRixHQUFVK0IsSUFBSWEsT0FBSixDQUFZdkMsRUFBRUwsS0FBZCxFQUFxQmtCLENBQXJCLENBQVYsQ0FBYixLQUNBO0FBQ0gsWUFBSUosSUFBSVQsRUFBRU4sSUFBVjtBQUNBLFlBQUk4QyxJQUFJeEMsRUFBRUwsS0FBVjtBQUNBLFlBQUksQ0FBQzZDLENBQUwsRUFBUSxPQUFPL0IsQ0FBUDs7QUFFUixZQUFJb0IsTUFBTVosWUFBWXVCLENBQVosQ0FBVjtBQUNBWCxZQUFJbEMsS0FBSixHQUFZd0IsZUFBZXFCLENBQWYsQ0FBWjtBQUNBWCxZQUFJbkMsSUFBSixHQUFXZSxDQUFYO0FBQ0EsZUFBT0UsU0FBU2tCLEdBQVQsQ0FBUDtBQUNEO0FBQ0QsYUFBT2xCLFNBQVNYLENBQVQsQ0FBUDtBQUNELEtBckZPOztBQXVGUnlDLGNBQVUsVUFBUzVCLENBQVQsRUFBWTtBQUNwQixVQUFJNkIsTUFBTWhCLElBQUlTLEVBQUosQ0FBT3RCLENBQVAsQ0FBVjtBQUNBYSxVQUFJQyxJQUFKLEdBQVdELElBQUlhLE9BQUosQ0FBWWIsSUFBSUMsSUFBaEIsRUFBc0JlLEdBQXRCLENBQVg7QUFDRCxLQTFGTzs7QUE0RlJDLGFBQVMsWUFBVztBQUNsQixVQUFJakIsSUFBSUMsSUFBSixLQUFhLElBQWpCLEVBQXVCLE9BQU8sRUFBUDtBQUN2QixhQUFPUCxTQUFTTSxJQUFJQyxJQUFiLENBQVA7QUFDRDtBQS9GTyxHQUFWO0FBaUdBLFNBQU9ELEdBQVA7QUFDRCxDQXBHRDs7QUFzR0FrQixPQUFPQyxPQUFQLEdBQWlCckIsT0FBakIiLCJmaWxlIjoiYXZsVHJlZS5qcyIsInNvdXJjZXNDb250ZW50IjpbIi8qIGpzY3M6ZGlzYWJsZSAqL1xuLyogZXNsaW50LWRpc2FibGUgKi9cblxuJ3VzZSBzdHJpY3QnO1xuXG5mdW5jdGlvbiBjcmVhdGVOZXdOb2RlXyhrZXkpIHtcbiAgcmV0dXJuIHtcbiAgICBrZXk6IGtleSxcbiAgICB3ZWlnaHQ6IDEsXG4gICAgaGVpZ2h0OiAwLFxuICAgIGxlZnQ6IG51bGwsXG4gICAgcmlnaHQ6IG51bGxcbiAgfTtcbn1cblxudmFyIGNvbXBhcmVyXyA9IGZ1bmN0aW9uKGEsIGIpIHtcbiAgaWYgKGEgPCBiKSByZXR1cm4gLTE7XG4gIGlmIChhID4gYikgcmV0dXJuIDE7XG4gIHJldHVybiAwO1xufVxuXG5mdW5jdGlvbiBoZWlnaHRfKHApIHtcbiAgcmV0dXJuIHAgPyBwLmhlaWdodCA6IDA7XG59XG5cbmZ1bmN0aW9uIHdlaWdodF8ocCkge1xuICByZXR1cm4gcCA/IHAud2VpZ2h0IDogMDtcbn1cblxuZnVuY3Rpb24gYkZhY3Rvcl8ocCkge1xuICByZXR1cm4gaGVpZ2h0XyhwLnJpZ2h0KSAtIGhlaWdodF8ocC5sZWZ0KTtcbn1cblxuZnVuY3Rpb24gY291bnRIZWlnaHRBbmRXZWlnaHRfKHApIHtcbiAgdmFyIGhsID0gaGVpZ2h0XyhwLmxlZnQpO1xuICB2YXIgaHIgPSBoZWlnaHRfKHAucmlnaHQpO1xuICBwLmhlaWdodCA9IChobCA+IGhyID8gaGwgOiBocikgKyAxO1xuXG4gIHZhciB3bCA9IHdlaWdodF8ocC5sZWZ0KTtcbiAgdmFyIHdyID0gd2VpZ2h0XyhwLnJpZ2h0KTtcbiAgcC53ZWlnaHQgPSB3bCArIHdyICsgMTtcbn1cblxuZnVuY3Rpb24gcm90YXRlUmlnaHRfKHApIHtcbiAgdmFyIHEgPSBwLmxlZnQ7XG4gIHAubGVmdCA9IHEucmlnaHQ7XG4gIHEucmlnaHQgPSBwO1xuICBjb3VudEhlaWdodEFuZFdlaWdodF8ocCk7XG4gIGNvdW50SGVpZ2h0QW5kV2VpZ2h0XyhxKTtcbiAgcmV0dXJuIHE7XG59XG5cbmZ1bmN0aW9uIHJvdGF0ZUxlZnRfKHEpIHtcbiAgdmFyIHAgPSBxLnJpZ2h0O1xuICBxLnJpZ2h0ID0gcC5sZWZ0O1xuICBwLmxlZnQgPSBxO1xuICBjb3VudEhlaWdodEFuZFdlaWdodF8ocSk7XG4gIGNvdW50SGVpZ2h0QW5kV2VpZ2h0XyhwKTtcbiAgcmV0dXJuIHA7XG59XG5cbmZ1bmN0aW9uIGJhbGFuY2VfKHApIHtcbiAgY291bnRIZWlnaHRBbmRXZWlnaHRfKHApO1xuICBpZiAoYkZhY3Rvcl8ocCkgPT09IDIpIHtcbiAgICBpZiAoYkZhY3Rvcl8ocC5yaWdodCkgPCAwKVxuICAgICAgcC5yaWdodCA9IHJvdGF0ZVJpZ2h0XyhwLnJpZ2h0KTtcbiAgICByZXR1cm4gcm90YXRlTGVmdF8ocCk7XG4gIH1cbiAgaWYgKGJGYWN0b3JfKHApID09PSAtMikge1xuICAgIGlmIChiRmFjdG9yXyhwLmxlZnQpID4gMClcbiAgICAgIHAubGVmdCA9IHJvdGF0ZUxlZnRfKHAubGVmdCk7XG4gICAgcmV0dXJuIHJvdGF0ZVJpZ2h0XyhwKTtcbiAgfVxuICByZXR1cm4gcDtcbn1cblxuZnVuY3Rpb24gY291bnRfKHAsIGspIHtcbiAgcmV0dXJuIHVwcGVyQm91bmRfKHAsIGspIC0gbG93ZXJCb3VuZF8ocCwgayk7XG59XG5cbmZ1bmN0aW9uIGF0XyhwLCBrKSB7XG4gIGlmICghcCkgcmV0dXJuIG51bGw7XG4gIHZhciB3bCA9IHdlaWdodF8ocC5sZWZ0KTtcbiAgaWYgKHdsIDw9IGsgJiYgayA8IHdsICsgMSkgcmV0dXJuIHAua2V5O1xuICBlbHNlIGlmIChrIDwgd2wpIHJldHVybiBhdF8ocC5sZWZ0LCBrKTtcbiAgZWxzZSByZXR1cm4gYXRfKHAucmlnaHQsIGsgLSB3bCAtIDEpO1xufVxuXG5mdW5jdGlvbiBnZXRNaW5pbXVtXyhwKSB7XG4gIGlmICghcCkgcmV0dXJuIG51bGw7XG4gIHJldHVybiBwLmxlZnQgPyBnZXRNaW5pbXVtXyhwLmxlZnQpIDogcDtcbn1cblxuZnVuY3Rpb24gZ2V0TWF4aW11bV8ocCkge1xuICBpZiAoIXApIHJldHVybiBudWxsO1xuICByZXR1cm4gcC5yaWdodCA/IGdldE1heGltdW1fKHAucmlnaHQpIDogcDtcbn1cblxuZnVuY3Rpb24gcmVtb3ZlTWluaW11bl8ocCkge1xuICBpZiAoIXAubGVmdCkgcmV0dXJuIHAucmlnaHQ7XG4gIHAubGVmdCA9IHJlbW92ZU1pbmltdW5fKHAubGVmdCk7XG4gIHJldHVybiBiYWxhbmNlXyhwKTtcbn1cblxuZnVuY3Rpb24gdG9BcnJheV8ocCkge1xuICB2YXIgYXJyID0gW107XG4gIGlmIChwLmxlZnQpIGFyciA9IGFyci5jb25jYXQodG9BcnJheV8ocC5sZWZ0KSk7XG4gIGFyci5wdXNoKHAua2V5KTtcbiAgaWYgKHAucmlnaHQpIGFyciA9IGFyci5jb25jYXQodG9BcnJheV8ocC5yaWdodCkpO1xuICByZXR1cm4gYXJyO1xufVxuXG52YXIgQVZMVHJlZSA9IGZ1bmN0aW9uKGNvbXBhcmVyKSB7XG4gIGlmICghY29tcGFyZXIpIGNvbXBhcmVyID0gY29tcGFyZXJfO1xuICB2YXIgQVZMID0ge1xuICAgIHJvb3Q6IG51bGwsXG4gICAgY29tcGFyZXJfOiBjb21wYXJlcixcblxuICAgIHNpemU6IGZ1bmN0aW9uKCkge1xuICAgICAgcmV0dXJuIHdlaWdodF8oQVZMLnJvb3QpO1xuICAgIH0sXG5cbiAgICBtaW46IGZ1bmN0aW9uKCkge1xuICAgICAgdmFyIHAgPSBnZXRNaW5pbXVtXyhBVkwucm9vdCk7XG4gICAgICBpZiAocCkgcmV0dXJuIHAua2V5O1xuICAgICAgcmV0dXJuIG51bGw7XG4gICAgfSxcblxuICAgIG1heDogZnVuY3Rpb24oKSB7XG4gICAgICB2YXIgcCA9IGdldE1heGltdW1fKEFWTC5yb290KTtcbiAgICAgIGlmIChwKSByZXR1cm4gcC5rZXk7XG4gICAgICByZXR1cm4gbnVsbDtcbiAgICB9LFxuXG4gICAgbG93ZXJCb3VuZDogZnVuY3Rpb24oaykge1xuICAgICAgcmV0dXJuIEFWTC5sb3dlckJvdW5kXyhBVkwucm9vdCwgayk7XG4gICAgfSxcbiAgICBsb3dlckJvdW5kXyhwLCBrKSB7XG4gICAgICBpZiAoIXApIHJldHVybiAwO1xuICAgICAgdmFyIGNtcCA9IEFWTC5jb21wYXJlcl8oaywgcC5rZXkpO1xuXG4gICAgICBpZiAoY21wIDw9IDApIHJldHVybiBBVkwubG93ZXJCb3VuZF8ocC5sZWZ0LCBrKTtcbiAgICAgIGVsc2UgaWYgKGNtcCA+IDApIHJldHVybiB3ZWlnaHRfKHAubGVmdCkgKyBBVkwubG93ZXJCb3VuZF8ocC5yaWdodCwgaykgKyAxO1xuICAgIH0sXG5cbiAgICB1cHBlckJvdW5kOiBmdW5jdGlvbihrKSB7XG4gICAgICByZXR1cm4gQVZMLnVwcGVyQm91bmRfKEFWTC5yb290LCBrKTtcbiAgICB9LFxuXG4gICAgdXBwZXJCb3VuZF8ocCwgaykge1xuICAgICAgaWYgKCFwKSByZXR1cm4gMDtcbiAgICAgIHZhciBjbXAgPSBBVkwuY29tcGFyZXJfKGssIHAua2V5KTtcblxuICAgICAgaWYgKGNtcCA8IDApIHJldHVybiBBVkwudXBwZXJCb3VuZF8ocC5sZWZ0LCBrKTtcbiAgICAgIGVsc2UgaWYgKGNtcCA+PSAwKSByZXR1cm4gd2VpZ2h0XyhwLmxlZnQpICsgQVZMLnVwcGVyQm91bmRfKHAucmlnaHQsIGspICsgMTtcbiAgICB9LFxuXG4gICAgY291bnQ6IGZ1bmN0aW9uKGspIHtcbiAgICAgIHJldHVybiBjb3VudF8oQVZMLnJvb3QsIGspO1xuICAgIH0sXG5cbiAgICBhdDogZnVuY3Rpb24oaykge1xuICAgICAgcmV0dXJuIGF0XyhBVkwucm9vdCwgayk7XG4gICAgfSxcblxuICAgIGluc2VydDogZnVuY3Rpb24oaykge1xuICAgICAgQVZMLnJvb3QgPSBBVkwuaW5zZXJ0XyhBVkwucm9vdCwgayk7XG4gICAgfSxcblxuICAgIGluc2VydF8ocCwgaykge1xuICAgICAgaWYgKCFwKSByZXR1cm4gY3JlYXRlTmV3Tm9kZV8oayk7XG4gICAgICB2YXIgY21wID0gQVZMLmNvbXBhcmVyXyhrLCBwLmtleSk7XG5cbiAgICAgIGlmIChjbXAgPCAwKSBwLmxlZnQgPSBBVkwuaW5zZXJ0XyhwLmxlZnQsIGspO1xuICAgICAgZWxzZSBpZiAoY21wID49IDApIHAucmlnaHQgPSBBVkwuaW5zZXJ0XyhwLnJpZ2h0LCBrKTtcbiAgICAgIHJldHVybiBiYWxhbmNlXyhwKTtcbiAgICB9LFxuXG4gICAgcmVtb3ZlOiBmdW5jdGlvbihrKSB7XG4gICAgICBBVkwucm9vdCA9IEFWTC5yZW1vdmVfKEFWTC5yb290LCBrKTtcbiAgICB9LFxuXG4gICAgcmVtb3ZlXyhwLCBrKSB7XG4gICAgICBpZiAoIXApIHJldHVybiBudWxsO1xuICAgICAgdmFyIGNtcCA9IEFWTC5jb21wYXJlcl8oaywgcC5rZXkpO1xuXG4gICAgICBpZiAoY21wIDwgMCkgcC5sZWZ0ID0gQVZMLnJlbW92ZV8ocC5sZWZ0LCBrKTtcbiAgICAgIGVsc2UgaWYgKGNtcCA+IDApIHAucmlnaHQgPSBBVkwucmVtb3ZlXyhwLnJpZ2h0LCBrKTtcbiAgICAgIGVsc2Uge1xuICAgICAgICB2YXIgcSA9IHAubGVmdDtcbiAgICAgICAgdmFyIHIgPSBwLnJpZ2h0O1xuICAgICAgICBpZiAoIXIpIHJldHVybiBxO1xuXG4gICAgICAgIHZhciBtaW4gPSBnZXRNaW5pbXVtXyhyKTtcbiAgICAgICAgbWluLnJpZ2h0ID0gcmVtb3ZlTWluaW11bl8ocik7XG4gICAgICAgIG1pbi5sZWZ0ID0gcTtcbiAgICAgICAgcmV0dXJuIGJhbGFuY2VfKG1pbik7XG4gICAgICB9XG4gICAgICByZXR1cm4gYmFsYW5jZV8ocCk7XG4gICAgfSxcblxuICAgIHJlbW92ZUF0OiBmdW5jdGlvbihrKSB7XG4gICAgICB2YXIgdmFsID0gQVZMLmF0KGspO1xuICAgICAgQVZMLnJvb3QgPSBBVkwucmVtb3ZlXyhBVkwucm9vdCwgdmFsKTtcbiAgICB9LFxuXG4gICAgdG9BcnJheTogZnVuY3Rpb24oKSB7XG4gICAgICBpZiAoQVZMLnJvb3QgPT09IG51bGwpIHJldHVybiBbXTtcbiAgICAgIHJldHVybiB0b0FycmF5XyhBVkwucm9vdCk7XG4gICAgfVxuICB9XG4gIHJldHVybiBBVkw7XG59XG5cbm1vZHVsZS5leHBvcnRzID0gQVZMVHJlZTtcbiJdfQ==