'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _avlTreeReservoir = require('./avlTreeReservoir');

var _avlTreeReservoir2 = _interopRequireDefault(_avlTreeReservoir);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Statistical reservoir of a fixed size capable calculating percentiles
 * This reservoir is derived from https://www.npmjs.com/package/reservoir
 * and was integrated with an avl tree (https://www.npmjs.com/package/avl-sorted-list)
 */
class StatisticalReservoir {

  /**
   * Constructs reservoir
   * @param {number} size Reservoir size
   * @param {number} interval reservoir interval in milliseconds
   * @param {Function} randomNumberGen custom random generator
   */
  constructor(size, interval, randomNumberGen) {
    this.reservoir = (0, _avlTreeReservoir2.default)(size, interval, randomNumberGen);
    this.length = this.reservoir.size();
  }

  /**
   * Add element to reservoir
   * @param {Number} data to add
   */
  pushMeasurement(data) {
    this.reservoir.pushSome(data);
    this.length = this.reservoir.size();
  }

  /**
   * Calculate percentile statistics for values stored in reservoir.
   * @param {Number} p - value in percents from 0 to 100
   * @return {Number} percentile value
   */
  getPercentile(p) {
    this.length = this.reservoir.size();
    return this.reservoir.getPercentile(p);
  }

  /**
   * Restore reservoir from saving data
   * @param {Object} value - stored value 
   */
  restoreValues(value) {
    this.reservoir.restoreValues(value);
  }

  /**
   * 
   * @return {Array} - reservoir array
   */
  toArray() {
    return this.reservoir.toArray();
  }

  toValueArray() {
    return this.reservoir.toValueArray();
  }
}
exports.default = StatisticalReservoir;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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